implementation module StdTimer


//	Clean Object I/O library, version 1.1


import	StdInt, StdBool, StdList, StdTuple
import	StdTimerElementClass, id, timerdefaccess, timeraccess, timerdevice, iostate
// RWS +++
import commondef
// PA+++
from	StdSystem	import ticksPerSecond


// PA---TicksPerSecond :== 1000


//	Open timer:

class Timers tdef
where
	openTimer	:: .ls !(tdef .ls (PSt .l .p)) !(PSt .l .p)	-> (!ErrorReport,!PSt .l .p)
	getTimerType::      (tdef .ls .ps)						-> TimerType

instance Timers (Timer t)	| TimerElements t
where
	openTimer :: .ls !(Timer t .ls (PSt .l .p)) !(PSt .l .p) -> (!ErrorReport,!PSt .l .p)	| TimerElements t
	openTimer ls tDef pState=:{io=ioState}
		# (tHs,ioState)			= IOStGetTimerHandles ioState
		# (pid,ioState)			= IOStGetIOId ioState
		# (rt,ioState)			= IOStGetReceiverTable ioState
		# (tt,ioState)			= IOStGetTimerTable ioState
		  (error,rt,tt,tHs)		= opentimer ls tDef pid rt tt tHs
		# ioState				= IOStSetTimerTable tt ioState
		# ioState				= IOStSetReceiverTable rt ioState
		# ioState				= IOStSetDevice (TimerSystemState tHs) ioState
		= (error,{pState & io=ioState})
	where
		opentimer :: .ls !(Timer t .ls .ps) !SystemId !ReceiverTable !TimerTable !(TimerHandles .ps)
									-> (!ErrorReport, !ReceiverTable,!TimerTable, !TimerHandles .ps)	| TimerElements t
		opentimer ls tDef pid rt tt timers=:{tSysIds=sysids,tTimers=tHs}
			# (alreadyOpen,tHs)		= if hasIdAttribute (UContains (eqTimerStateHandleId id) tHs) (False,tHs)
			| alreadyOpen
			= (ErrorIdsInUse,rt,tt,{timers & tTimers=tHs})
			# items					= timerDefGetElements tDef
			  itemHs				= timerElementToHandles items
			  (sysid,sysids1)		= if hasIdAttribute (id,sysids) (HdTl sysids)
			  (ok,itemHs,rt)		= noDuplicateTimerReceiverIds pid sysid itemHs rt
			| not ok
			= (ErrorIdsInUse,rt,tt,{timers & tTimers=tHs})
			# tH					= {	tId			= sysid
									  ,	tSelect		= able_timer
									  ,	tPeriod		= period
									  ,	tFun		= f
									//,	tSample		= now
									//,	tLS			= True
									  ,	tItems		= map TimerElementStateToTimerElementHandle itemHs
									  }
			  tsH					= TimerLSHandle {tState=ls,tHandle=tH}
			  tLoc					= {	tlIOId		= pid
									  ,	tlDevice	= TimerDevice
									  ,	tlParentId	= sysid
									  ,	tlTimerId	= sysid
									  }
			  tt					= if able_timer (snd (addTimerToTimerTable tLoc period tt)) tt
			= (NoError,rt,tt,{timers & tSysIds=sysids1,tTimers=[tsH:tHs]})
		where
			(optid,select,period,f)	= timerDefGetAttributes (validateTimerDef tDef)
			able_timer				= enabled select
			hasIdAttribute			= isJust optid
			id						= fromJust optid
			
			validateTimerDef :: !(Timer t .ls .ps) -> Timer t .ls .ps
			validateTimerDef tDef
				# (_,_,period,_)	= timerDefGetAttributes tDef
				| period>=0
				= tDef
				= timerDefSetInterval tDef 0
	
	getTimerType :: (Timer t .ls .ps) -> TimerType	| TimerElements t
	getTimerType _
		= "Timer"

eqTimerStateHandleId :: !Id !(TimerStateHandle .ps) -> (!Bool,!TimerStateHandle .ps)
eqTimerStateHandleId id tsH=:(TimerLSHandle {tHandle={tId}})
	= (id==tId,tsH)


//	Close timer:

closeTimer :: !Id !(IOSt .l .p) -> IOSt .l .p
closeTimer id ioState
	# (tHs,ioState)			= IOStGetTimerHandles ioState
	# (pid,ioState)			= IOStGetIOId ioState
	# (rt,ioState)			= IOStGetReceiverTable ioState
	# (tt,ioState)			= IOStGetTimerTable ioState
	  (rt,tt,tsHs,sysids)	= closetimer id pid rt tt tHs.tTimers tHs.tSysIds
	# ioState				= IOStSetReceiverTable rt ioState
	# ioState				= IOStSetTimerTable tt ioState
	  tHs					= {tHs & tTimers=tsHs,tSysIds=sysids}
	# ioState				= IOStSetDevice (TimerSystemState tHs) ioState
	= ioState
where
	closetimer :: !Id !SystemId !ReceiverTable !TimerTable ![TimerStateHandle .ps] ![Id]
							-> (!ReceiverTable,!TimerTable,![TimerStateHandle .ps],![Id])
	closetimer id pid rt tt [tsH:tsHs] sysids
		# (eqid,tsH) = eqTimerStateHandleId id tsH
		| eqid
		  = (rt1,tt1,tsHs,if (isSysId id) [id:sysids] sysids)
		with
			rt1			= disposeRIds tsH rt
			teLoc		= {tlIOId=pid,tlDevice=TimerDevice,tlParentId=id,tlTimerId=id}
			(_,tt1)		= removeTimerFromTimerTable teLoc tt
		# (rt,tt,tsHs,sysids)	= closetimer id pid rt tt tsHs sysids
		= (rt,tt,[tsH:tsHs],sysids)
	where
		disposeRIds :: !(TimerStateHandle .ps) !ReceiverTable -> ReceiverTable
		disposeRIds (TimerLSHandle {tHandle={tItems}}) rt
			= StateMap2 disposeReceiverTableEntries tItems rt
	closetimer _ _ rt tt _ sysids
		= (rt,tt,[],sysids)


//	Get the Ids and TimerTypes of all timers:

getTimers :: !(IOSt .l .p) -> ([(Id,TimerType)],!IOSt .l .p)
getTimers ioState
	# (tHs,ioState)		= IOStGetTimerHandles ioState
	  (idtypes,timers)	= getidtypes tHs.tTimers
	  tHs				= {tHs & tTimers=timers}
	# ioState			= IOStSetDevice (TimerSystemState tHs) ioState
	= (idtypes,ioState)
where
	getidtypes :: ![TimerStateHandle .ps] -> (![(Id,TimerType)],![TimerStateHandle .ps])
	getidtypes [TimerLSHandle tlsH=:{tHandle=tH}:tsHs]
		# (idtype, tH)	= getidtype  tH
		  (idtypes,tsHs)= getidtypes tsHs
		= ([idtype:idtypes],[TimerLSHandle {tlsH & tHandle=tH}:tsHs])
	where
		getidtype :: !(TimerHandle .ls .ps) -> ((Id,TimerType),!TimerHandle .ls .ps)
		getidtype tH=:{tId}
			= ((tId,"Timer"),tH)
	getidtypes _
		= ([],[])


//	Enabling and Disabling of timers:

enableTimer :: !Id !(IOSt .l .p) -> IOSt .l .p
enableTimer id ioState
	= changeTimer id enabletimer ioState
where
	enabletimer :: TimerLoc !TimerTable !(TimerStateHandle .ps) -> (!TimerTable, !TimerStateHandle .ps)
	enabletimer teLoc tt tlsH=:(TimerLSHandle tsH=:{tHandle=tH=:{tSelect,tPeriod}})
		| tSelect
		= (tt,tlsH)
		# (_,tt)	= addTimerToTimerTable teLoc tPeriod tt
		= (tt,TimerLSHandle {tsH & tHandle={tH & tSelect=True}})

disableTimer :: !Id !(IOSt .l .p) -> IOSt .l .p
disableTimer id ioState
	= changeTimer id disabletimer ioState
where
	disabletimer :: TimerLoc !TimerTable !(TimerStateHandle .ps) -> (!TimerTable, !TimerStateHandle .ps)
	disabletimer teLoc tt tlsH=:(TimerLSHandle tsH=:{tHandle=tH=:{tSelect}})
		| not tSelect
		= (tt,tlsH)
		# (_,tt)= removeTimerFromTimerTable teLoc tt
		= (tt,TimerLSHandle {tsH & tHandle={tH & tSelect=False}})


//	Get the SelectState of timers:

getTimerSelectState :: !Id !(IOSt .l .p) -> (!Maybe SelectState,!IOSt .l .p)
getTimerSelectState id ioState
	# (tHs, ioState)		= IOStGetTimerHandles ioState
	  (maybe_select,timers)	= gettimerselect id tHs.tTimers
	  tHs					= {tHs & tTimers=timers}
	# ioState				= IOStSetDevice (TimerSystemState tHs) ioState
	= (maybe_select,ioState)
where
	gettimerselect :: !Id ![TimerStateHandle .ps] -> (!Maybe SelectState, ![TimerStateHandle .ps])
	gettimerselect id [tsH=:(TimerLSHandle {tHandle={tId,tSelect}}):tsHs]
		| id==tId			= (Just (if tSelect Able Unable),[tsH:tsHs])
		# (optselect,tsHs)	= gettimerselect id tsHs
		= (optselect,[tsH:tsHs])
	gettimerselect _ _
		= (Nothing,[])


//	Set the TimerInterval of timers:

setTimerInterval :: !Id !TimerInterval !(IOSt .l .p) -> IOSt .l .p
setTimerInterval id interval ioState
	= changeTimer id (settimerinterval interval) ioState
where
	settimerinterval :: !TimerInterval !TimerLoc !TimerTable !(TimerStateHandle .ps) -> (!TimerTable, !TimerStateHandle .ps)
	settimerinterval period teLoc tt tlsH=:(TimerLSHandle tsH=:{tHandle=tH=:{tSelect,tPeriod}})
		# period	= max 0 period
		| period==tPeriod
		= (tt,tlsH)
		# tlsH		= TimerLSHandle {tsH & tHandle={tH & tPeriod=period}}
		| not tSelect
		= (tt,tlsH)
		# (_,tt)	= setIntervalInTimerTable teLoc period tt
		= (tt,tlsH)


//	Get the TimerInterval of timers:

getTimerInterval :: !Id !(IOSt .l .p) -> (!Maybe TimerInterval,!IOSt .l .p)
getTimerInterval id ioState
	# (tHs, ioState)		= IOStGetTimerHandles ioState
	  (optinterval,timers)	= gettimerinterval id tHs.tTimers
	  tHs					= {tHs & tTimers=timers}
	# ioState				= IOStSetDevice (TimerSystemState tHs) ioState
	= (optinterval,ioState)
where
	gettimerinterval :: !Id ![TimerStateHandle .ps] -> (!Maybe TimerInterval, ![TimerStateHandle .ps])
	gettimerinterval id [tsH=:(TimerLSHandle {tHandle={tId,tPeriod}}):tsHs]
		| id==tId
		= (Just tPeriod,[tsH:tsHs])
		# (optselect,tsHs)	= gettimerinterval id tsHs
		= (optselect,  [tsH:tsHs])
	gettimerinterval _ _
		= (Nothing,[])


IOStGetTimerHandles :: !(IOSt .l .p) -> (!TimerHandles (PSt .l .p), !IOSt .l .p)
IOStGetTimerHandles ioState
	# (tHs, ioState) = IOStGetDevice TimerDevice ioState
	= (TimerSystemStateGetTimerHandles tHs, ioState)


//	General TimerHandle changing function:

::	DeltaTimerStateHandle ps
	:== TimerLoc TimerTable (TimerStateHandle ps) -> (TimerTable,TimerStateHandle ps)

changeTimer :: !Id !(DeltaTimerStateHandle (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
changeTimer id f ioState
	# (tHs, ioState)	= IOStGetTimerHandles ioState
	# (tt,  ioState)	= IOStGetTimerTable   ioState
	# (ioid,ioState)	= IOStGetIOId         ioState
	  (tt,tHs)			= changetimerdevice ioid id f tt tHs
	# ioState			= IOStSetDevice (TimerSystemState tHs) ioState
	# ioState			= IOStSetTimerTable tt ioState
	= ioState
where
	changetimerdevice :: SystemId !Id (DeltaTimerStateHandle .ps) !TimerTable !(TimerHandles .ps)
															  -> (!TimerTable, !TimerHandles .ps)
	changetimerdevice ioid id f tt timers=:{tTimers=tsHs}
		# (tt,tsHs)		= changetimerstatehandles ioid id f tt tsHs
		= (tt,{timers & tTimers=tsHs})
	where
		changetimerstatehandles :: SystemId !Id (DeltaTimerStateHandle .ps) !TimerTable ![TimerStateHandle .ps]
																		-> (!TimerTable,![TimerStateHandle .ps])
		changetimerstatehandles ioid id f tt [tsH=:(TimerLSHandle {tHandle={tId}}):tsHs]
			| id==tId
			= (tt1,[tsH1:tsHs])
			with
				teLoc		= {tlIOId=ioid,tlDevice=TimerDevice,tlParentId=id,tlTimerId=id}
				(tt1,tsH1)	= f teLoc tt tsH
			= (tt1,[tsH:tsHs1])
			with
				(tt1,tsHs1)	= changetimerstatehandles ioid id f tt tsHs
		changetimerstatehandles _ _ _ tt tsHs
			= (tt,tsHs)
